﻿using System;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Markup;

namespace MetroXamlpad
{
    partial class MainPage
    {
        DispatcherTimer _timer;

        public MainPage()
        {
            InitializeComponent();

            _timer = new DispatcherTimer();
            _timer.Interval = TimeSpan.FromSeconds(2.0);
            _timer.Tick += (object sender, object e) => { attemptXamlLoad(); };

            xamlEditor.Text =
@"<Grid
    xmlns=""http://schemas.microsoft.com/winfx/2006/xaml/presentation""
    xmlns:x=""http://schemas.microsoft.com/winfx/2006/xaml""
    Background=""White"">
    
</Grid>";
            attemptXamlLoad();
        }

        private void attemptXamlLoad()
        {
            bool exceptionCaught = false;
            object obj = null;
            UIElement result = null;

            if (string.IsNullOrWhiteSpace(xamlEditor.Text))
            {
                errorDisplay.Text = @"Xaml Editor is empty";
                return;
            }

            try
            {
                obj = XamlReader.Load(xamlEditor.Text);
                result = obj as UIElement;
                errorDisplay.Text = "";
            }
            catch (Exception ex)
            {
                errorDisplay.Text = ex.ToString();
                exceptionCaught = true;
            }

            if (result != null)
            {
                host.Children.Clear();
                host.Children.Add(result);
            }
            else
            {
                if (exceptionCaught == false)
                    errorDisplay.Text = @"No exception yet null result.";
            }
        }

        private void restartTimer()
        {
            _timer.Stop();
            _timer.Start();
        }

        private void xamlEditor_KeyDown(object sender, Windows.UI.Xaml.Input.KeyEventArgs e)
        {
            restartTimer();
        }

        private void xamlEditor_KeyUp(object sender, Windows.UI.Xaml.Input.KeyEventArgs e)
        {
            restartTimer();
        }

        private void xamlEditor_LostFocus(object sender, RoutedEventArgs e)
        {
            attemptXamlLoad();
        }
    }
}
